Attribute VB_Name = "modChatEvents"
Option Explicit

Private ChanHandler As New clsHandlerChannel

Private Const EID_EMOTE = &H17
Private Const EID_WHISPTO = &HA
Private Const EID_WHISPFROM = &H4
Private Const EID_TALK = &H5
Private Const EID_USER = &H1
Private Const EID_JOIN = &H2
Private Const EID_LEAVE = &H3
Private Const EID_FLAGS = &H9
Private Const EID_CHAN = &H7
Private Const EID_ERROR = &H13
Private Const EID_INFO = &H12
Private Const EID_NOTEXIST = &HE
Private Const EID_BROADCAST = &H6
Private Const EID_RESTRICTED = &HF
Private Const EID_CHANFULL = &HD

Private Const BNFLAGS_PUBCHAN = &H1
Private Const BNFLAGS_MODCHAN = &H2
Private Const BNFLAGS_RESTRICTED = &H4
Private Const BNFLAGS_SILENT = &H8
Private Const BNFLAGS_SYSTEM = &H10
Private Const BNFLAGS_PRODUCTSPEC = &H20
Private Const BNFLAGS_REDIRECTED = &H4000
Private Const BNFLAGS_GLOBAL = &H1000

Public Sub EVENTHandler(ByVal Index As Integer, ByVal EID As Long, ByVal Username As String, ByVal Client As String, ByVal Flags As Long, ByVal Ping As Long, ByVal Message As String)
    Call convertD2Username(Username)
    
    Select Case EID
        'Speech Events
        Case EID_TALK, EID_EMOTE, EID_WHISPFROM, EID_WHISPTO
            Call chatEvents(Index, EID, Username, Flags, Ping, Message)
            If ((EID And EID_WHISPTO) <> EID_WHISPTO And StrComp(Username, Bots(Index).RealUsername, vbTextCompare) <> 0 And (G_Options.Flash_Window_Reply)) Then
                Call Flash_Window
            End If
            
        'User Events
        Case EID_USER, EID_JOIN, EID_LEAVE, EID_FLAGS
            Call userEvents(Index, EID, Username, Flags, Ping, Client, Message)
            Call updateBotChannel(Index, Bots(Index).CurrentChannel)
                
        'Informational Events
        Case EID_CHAN
            Bots(Index).Connected = True
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, "Joined Channel: ", COLORS.ID_COLOR_NORMAL, Message & " (" & getChannelInformation(Flags) & ")"
            If (BotIndex = Index) Then
                frmMain.lvUsers.ListItems.Clear
            End If
            Call updateBotChannel(Index, Message)
            Call ProfileHandler(Index).UserListing.Reset(CHANNEL_USER)
            'Set inchannel uptime
            ProfileHandler(Index).UPTIME_INCHANNEL = GetTickCount()
            
            If (StrComp(Message, "the void", vbTextCompare) = 0) Then  'The Void channel!
                If (G_Options.Join_Home_Error) Then 'Feature: When banned or kicked, join home.
                    Call AddQueue(Index, "/join " & Bots(Index).Home, 1)
                Else 'No point showing the void if you're going to rejoin a channel anyway.
                    If (G_Options.Show_Void) Then
                        Call AddQueue(Index, "/unignore " & Bots(Index).RealUsername)
                    End If
                End If
            End If
            
            'Store last channel
            Call ProfileHandler(Index).storeChannel(Message)
            
        Case EID_ERROR
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, Message
            
        Case EID_INFO
            
            'Filter the /away info message from bnet when auto-away is on
            If (StrComp(Message, "You are now marked as being away.", vbTextCompare) <> 0) Or (G_Options.Auto_Away = False) Or (((GetTickCount() - ProfileHandler(Index).UPTIME_IDLE) / 1000 / 60 / 60) < G_Settings.AutoAwayTime) Then
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, Message
            End If
            
        Case EID_NOTEXIST
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, Message
        Case EID_BROADCAST
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, Message
        Case EID_RESTRICTED
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, Message
        Case EID_CHANFULL
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, Message
    End Select
End Sub

Private Sub userEvents(ByVal Index As Integer, ByVal EID As Long, ByVal Username As String, ByVal Flags As Long, ByVal Ping As Long, ByVal Client As String, ByVal Message As String)
    Dim Color           As Long
    Dim Placement       As Integer
    Dim userPosition    As Integer
    
    userPosition = ChanHandler.findUserIndex(Username, frmMain.lvUsers)
    
    If ((Flags And BNFLAGS_BLIZZ) = BNFLAGS_BLIZZ) Then
        Color = COLORS.ID_COLOR_BLIZZARD
        Placement = 1
    ElseIf ((Flags And BNFLAGS_OP) = BNFLAGS_OP) Then
        Color = COLORS.ID_COLOR_OPERATOR
        Placement = 1
    ElseIf ((Flags And BNFLAGS_SQUELCH) = BNFLAGS_SQUELCH) Then
        Color = COLORS.ID_COLOR_SQUELCH
        Placement = frmMain.lvUsers.ListItems.Count + 1
        If (BotIndex = Index And userPosition > 0) Then
            Placement = userPosition
        End If
    Else
        Color = COLORS.ID_COLOR_NORMAL
        Placement = frmMain.lvUsers.ListItems.Count + 1
        If (BotIndex = Index And userPosition > 0) Then
            Placement = userPosition
        End If
    End If
    
    Dim Statstring      As String
    Dim HandlerStats    As New clsHandlerStats
    
    If ((EID And EID_LEAVE) <> EID_LEAVE Or (EID And EID_FLAGS) <> EID_FLAGS) Then
        Statstring = HandlerStats.preStatString(Message)
    End If
        
    With ChanHandler
        Select Case EID
            Case EID_USER
                Call ChanHandler.addUserToListView(Index, Placement, Username, Ping, Flags, Client, Color, .getProductIcon(Client, Flags), Statstring)
                
                If (G_Options.Chat_Filters = False Or BotFilters.getFilter(Username, F_USER) = False) Then
                    If (G_Options.On_User_Reply) Then
                        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_USER, Username & " [" & Ping & "ms] is here using " & ChanHandler.MakeLongClientName(Client) & " (" & Statstring & ")."
                    End If
                    If (G_Options.Last_Seen_Usage) Then
                        Call ProfileHandler(Index).Lastseen.addLastSeen(Username, Bots(Index).CurrentChannel, Client, Ping, Flags, frmMain.sckBNET(Index).RemoteHost, vbNull)
                    End If
                End If
                
            Case EID_JOIN
                Call ChanHandler.addUserToListView(Index, Placement, Username, Ping, Flags, Client, Color, .getProductIcon(Client, Flags), Statstring)
                If (G_Options.Chat_Filters = False Or BotFilters.getFilter(Username, F_USER) = False) Then
                    If (G_Options.Join_Leave_Reply) Then
                        If (G_Options.Parse_Stats) Then
                            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_JOIN, Username & " [" & Ping & "ms] has joined using " & ChanHandler.MakeLongClientName(Client) & " (" & Statstring & ")."
                        Else
                            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_JOIN, Username & " [" & Ping & "ms] has joined the channel."
                        End If
                    End If
                    If (G_Options.Last_Seen_Usage) Then
                        Call ProfileHandler(Index).Lastseen.addLastSeen(Username, Bots(Index).CurrentChannel, Client, Ping, Flags, frmMain.sckBNET(Index).RemoteHost, vbNull)
                    End If
                End If
                
            Case EID_LEAVE
                If (Index = BotIndex And userPosition > 0) Then
                    With frmMain.lvUsers
                        Call .ListItems.Remove(userPosition)
                    End With
                End If
                Call ProfileHandler(Index).UserListing.remUser(CHANNEL_USER, Username)
                If (G_Options.Chat_Filters = False Or BotFilters.getFilter(Username, F_USER) = False) Then
                    If (G_Options.Join_Leave_Reply) Then
                        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_JOIN, Username & " [" & Ping & "ms] has left the channel."
                    End If
                    If (G_Options.Last_Seen_Usage) Then
                        Call ProfileHandler(Index).Lastseen.addLastSeen(Username, Bots(Index).CurrentChannel, Client, Ping, Flags, frmMain.sckBNET(Index).RemoteHost, vbNull)
                    End If
                End If
                
            Case EID_FLAGS
                Call ChanHandler.addUserToListView(Index, Placement, Username, Ping, Flags, ProfileHandler(Index).UserListing.getUserProduct(Username), Color, .getProductIcon(Client, Flags), ProfileHandler(Index).UserListing.getUserStats(Username))
                If ((Flags And BNFLAGS_OP) = BNFLAGS_OP) Then
                    If (G_Options.Chat_Filters = False Or BotFilters.getFilter(Username, F_USER) = False) Then
                        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, Username & " [" & Ping & "ms] has gained operator status."
                        If (G_Options.Last_Seen_Usage) Then
                            Call ProfileHandler(Index).Lastseen.addLastSeen(Username, Bots(Index).CurrentChannel, Client, Ping, Flags, frmMain.sckBNET(Index).RemoteHost, vbNull)
                        End If
                    End If
                End If
                
        End Select
    End With
End Sub

Private Sub chatEvents(ByVal Index As Integer, ByVal EID As Long, ByVal Username As String, ByVal Flags As Long, ByVal Ping As Long, ByVal Message As String)

    'Alternate colors for clearity in messages
    If Bots(Index).AlternateColor = COLORS.ID_COLOR_NAMES Then
        Bots(Index).AlternateColor = COLORS.ID_COLOR_NAMES_2
    Else
        Bots(Index).AlternateColor = COLORS.ID_COLOR_NAMES
    End If
    
    'Just incase
    If Bots(Index).AlternateColor <= 0 Then Bots(Index).AlternateColor = RGB(255, 255, 255)
    
    'Battle.net Event ID's (Speech)
    If (G_Options.Chat_Filters = False Or (BotFilters.getFilter(Username, F_USER) = False And (BotFilters.getFilter(Message, F_MESSAGE) = False))) Then  'Filter check
        
        'Auto filters:
        If (G_Options.AutoFilters) Then
            'After the 2nd consecutive message, equivalent messages are not shown.
            If (DetectAutoFilters(Index, Username, Message, EID) = True) Then
                'Debug.Print "Filtered: " & Message
                Exit Sub
            End If
        End If
        
        'Update Idle Userlistings:
        If (Message <> vbNullString) Then
            Call ProfileHandler(Index).UserListing.updateUserIdleTime(Username)
        End If
        
        Select Case EID
            Case EID_TALK
                If ((Flags And BNFLAGS_BLIZZ) = BNFLAGS_BLIZZ) Then
                        If (G_Options.Chat_Brackets) Then
                            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_BLIZZARD, "<" & Username & "> ", COLORS.ID_COLOR_TALK, Message
                        Else
                            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_BLIZZARD, Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_TALK, Message
                        End If
                ElseIf ((Flags And BNFLAGS_OP) = BNFLAGS_OP) Then
                    If (G_Options.Chat_Brackets) Then
                        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_OPERATOR, "<" & Username & "> ", COLORS.ID_COLOR_TALK, Message
                    Else
                        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_OPERATOR, Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_TALK, Message
                    End If
                Else
                    If (G_Options.Chat_Brackets) Then
                        AddC Index, frmMain.rtbChat, True, Bots(Index).AlternateColor, "<" & Username & "> ", COLORS.ID_COLOR_TALK, Message
                    Else
                        AddC Index, frmMain.rtbChat, True, Bots(Index).AlternateColor, Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_TALK, Message
                    End If
                End If
                
            
            Case EID_EMOTE
                If (G_Options.Chat_Brackets) Then
                    AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_EMOTE, "<", Bots(Index).AlternateColor, Username, COLORS.ID_COLOR_EMOTE, Space(1) & Message & ">"
                Else
                    AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_EMOTE, "(Emote) " & Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_EMOTE, Message
                End If
                
            
            Case EID_WHISPFROM
                If (G_Options.Chat_Brackets) Then
                    AddC Index, frmMain.rtbWhisper, True, COLORS.ID_COLOR_WHISP_NAME, "<From " & Username & "> ", COLORS.ID_COLOR_WHISFROM, Message
                Else
                    AddC Index, frmMain.rtbWhisper, True, COLORS.ID_COLOR_WHISP_NAME, "From " & Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_WHISFROM, Message
                End If
                Bots(Index).LastWhisperUser = Username
                
            Case EID_WHISPTO
                If (G_Options.Chat_Brackets) Then
                    AddC Index, frmMain.rtbWhisper, True, COLORS.ID_COLOR_WHISP_NAME, "<To " & Username & "> ", COLORS.ID_COLOR_WHISTO, Message
                Else
                    AddC Index, frmMain.rtbWhisper, True, COLORS.ID_COLOR_WHISP_NAME, "To " & Username & ":" & Flags & ":" & Ping & ": ", COLORS.ID_COLOR_WHISTO, Message
                End If
        End Select
    End If
End Sub


Private Sub convertD2Username(ByRef Username As String)
    If (InStr(Username, "*")) Then
        Username = Split(Username, "*", 2)(1)
    End If
End Sub

Private Function getChannelInformation(ByVal Flags As Long) As String
    If (Flags And BNFLAGS_PUBCHAN) = BNFLAGS_PUBCHAN Then getChannelInformation = getChannelInformation & "Public Channel, "
    If (Flags And BNFLAGS_MODCHAN) = BNFLAGS_MODCHAN Then getChannelInformation = getChannelInformation & "Moderated, "
    If (Flags And BNFLAGS_RESTRICTED) = BNFLAGS_RESTRICTED Then getChannelInformation = getChannelInformation & "Restricted, "
    If (Flags And BNFLAGS_SILENT) = BNFLAGS_SILENT Then getChannelInformation = getChannelInformation & "Silent, "
    If (Flags And BNFLAGS_SYSTEM) = BNFLAGS_SYSTEM Then getChannelInformation = getChannelInformation & "System, "
    If (Flags And BNFLAGS_PRODUCTSPEC) = BNFLAGS_PRODUCTSPEC Then getChannelInformation = getChannelInformation & "Product-Specific, "
    If (Flags And BNFLAGS_REDIRECTED) = BNFLAGS_REDIRECTED Then getChannelInformation = getChannelInformation & "Redirected, "
    If (Flags And BNFLAGS_GLOBAL) = BNFLAGS_GLOBAL Then getChannelInformation = getChannelInformation & "Globally Accessible, "
    If (getChannelInformation = vbNullString) Then: getChannelInformation = getChannelInformation & "Private, "
    If Len(getChannelInformation) > 3 Then
        getChannelInformation = Left$(getChannelInformation, Len(getChannelInformation) - 2)
    End If
End Function

Private Function DetectAutoFilters(Index As Integer, Username As String, Message As String, EID As Long) As Boolean
    If ((EID And EID_WHISPTO) <> EID_WHISPTO) Then
        'Level 3: If third message returns true -> this is spam.
        If (ProfileHandler(Index).getLastMessage(1) = Message) Then
            DetectAutoFilters = True
        End If
        'Level 2
        If (ProfileHandler(Index).getLastMessage(0) = Message) Then
            Call ProfileHandler(Index).setLastMessage(1, Message)
        End If
        'Level 1
        Call ProfileHandler(Index).setLastMessage(0, Message)
    End If
End Function

